#ifndef CE2_TST_BASE64_H
#define CE2_TST_BASE64_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/
#include "CryptoEngine2.h"
#include "CE2_TST_Config.h"
#include "CE2_TST_Common.h"
#include <stdio.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Tue Jun 24 14:20:00 2008
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains test functions for Base64 encoding
* which worked with LibTomCrypt.
* 
* \version CE2_TST_Base64.h#1:csrc:1
* \author  Aliaksandr Masiuk
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/

#define TST_NAME_STRING_LEN 	 	 	 	 	 	150
#define TST_BASE64_MAX_INPUT_DATA_VEC_SIZE_IN_BYTES 1024
#define TST_BASE64_MAX_DATA_VEC_SIZE_IN_BYTES 	 	(4 * ((TST_BASE64_MAX_INPUT_DATA_VEC_SIZE_IN_BYTES + 2) / 3)) + 1

/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/

/* test data structure */
typedef struct TST_Base64_TestDataStruct
{	
	char		TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t 	TST_input_data[TST_BASE64_MAX_INPUT_DATA_VEC_SIZE_IN_BYTES];
	DxUint16_t	TST_input_dataSizeInBytes;
	DxUint8_t 	TST_output_data[TST_BASE64_MAX_DATA_VEC_SIZE_IN_BYTES];
	DxUint16_t	TST_output_dataSizeInBytes;
} TST_Base64_TestDataStruct;

/************************ Public Variables ********************/
/************************ Public Functions ********************/

/***************************************************************
* Function Name: 
*  CE2_TST_Base64
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  Test for CE2_Base64 methods.
***************************************************************/
CE2Error_t CE2_TST_Base64(FILE *out);

/***************************************************************
* Function Name: 
*  CE2_TST_Base64_Acceptance
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  Acceptance Test for CE2_Base64 methods.
***************************************************************/
CE2Error_t CE2_TST_Base64_Acceptance(FILE *out);

#ifdef __cplusplus
}
#endif

#endif /* CE2_TST_BASE64_H */
